/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.rotational_compressor;

import com.lgmrszd.compressedcreativity.blocks.rotational_compressor.RotationalCompressorBlock;
import com.lgmrszd.compressedcreativity.config.CommonConfig;
import com.lgmrszd.compressedcreativity.config.PressureTierConfig;
import com.lgmrszd.compressedcreativity.network.IObserveTileEntity;
import com.lgmrszd.compressedcreativity.network.ObservePacket;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RotationalCompressorTileEntity
extends KineticTileEntity
implements IObserveTileEntity {
    private static final Logger logger = LogManager.getLogger((String)"compressedcreativity");
    protected final IAirHandlerMachine airHandler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler(((PressureTierConfig.PressureTierEnum)((Object)CommonConfig.ROTATIONAL_COMPRESSOR_PRESSURE_TIER.get())).getPressureTierDefinedOrCustom(PressureTierConfig.CustomTier.ROTATIONAL_COMPRESSOR_CUSTOM_TIER), ((Integer)CommonConfig.ROTATIONAL_COMPRESSOR_VOLUME.get()).intValue());
    private final LazyOptional<IAirHandlerMachine> airHandlerCap = LazyOptional.of(() -> this.airHandler);
    private double airGeneratedPerTick = 0.0;
    private boolean updateGeneratedAir = true;
    private boolean isWrongDirection = false;
    private float airBuffer = 0.0f;

    public RotationalCompressorTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (added) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.pressure_summary")));
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.pressure").m_130940_(ChatFormatting.GRAY)));
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TextComponent(" " + this.airHandler.getPressure()).m_7220_((Component)new TranslatableComponent("compressedcreativity.unit.bar")).m_130940_(ChatFormatting.AQUA)));
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.air").m_130940_(ChatFormatting.GRAY)));
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TextComponent(" " + this.airHandler.getAir()).m_7220_((Component)new TranslatableComponent("compressedcreativity.unit.air")).m_130940_(ChatFormatting.AQUA)));
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.air_production").m_130940_(ChatFormatting.GRAY)));
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TextComponent(" " + (this.airGeneratedPerTick > 0.0 ? this.airGeneratedPerTick : 0.0)).m_7220_((Component)new TranslatableComponent("compressedcreativity.unit.air_per_tick")).m_130946_(" ").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)new TranslatableComponent("create.gui.goggles.at_current_speed").m_130940_(ChatFormatting.DARK_GRAY)));
        }
        return added;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.f_58858_, 0);
        boolean added = super.addToTooltip(tooltip, isPlayerSneaking);
        if (this.isWrongDirection) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.rotational_compressor.wrong_direction").m_130940_(ChatFormatting.GOLD)));
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.rotational_compressor.wrong_direction_desc").m_130940_(ChatFormatting.GRAY)));
            added = true;
        }
        return added;
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)((Integer)CommonConfig.ROTATIONAL_COMPRESSOR_STRESS.get()).intValue() / 256.0f;
        return impact;
    }

    public void initialize() {
        super.initialize();
        this.updateAirHandler();
    }

    public void m_7651_() {
        super.m_7651_();
        this.airHandlerCap.invalidate();
    }

    public void tick() {
        super.tick();
        this.airHandler.tick((BlockEntity)this);
        if (this.updateGeneratedAir) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
            float speed = RotationalCompressorTileEntity.convertToDirection((float)this.getSpeed(), (Direction)facing);
            this.isWrongDirection = speed < 0.0f;
            this.airGeneratedPerTick = speed > 0.0f && this.isSpeedRequirementFulfilled() ? (Double)CommonConfig.ROTATIONAL_COMPRESSOR_BASE_PRODUCTION.get() * (double)speed / 128.0 : 0.0;
            logger.debug("New air/t generated: " + this.airGeneratedPerTick);
            this.updateGeneratedAir = false;
            this.notifyUpdate();
        }
        if (this.m_58904_() != null && this.airGeneratedPerTick > 0.0) {
            if (!this.m_58904_().f_46443_) {
                this.airBuffer = (float)((double)this.airBuffer + this.airGeneratedPerTick);
                if (this.airBuffer >= 1.0f) {
                    int toAdd = (int)this.airBuffer;
                    this.airHandler.addAir(toAdd);
                    this.airBuffer -= (float)toAdd;
                }
            } else {
                this.spawnAirParticle();
            }
        }
    }

    private void spawnAirParticle() {
        Direction orientation = (Direction)this.m_58900_().m_61143_(RotationalCompressorBlock.HORIZONTAL_FACING);
        if (this.m_58904_().f_46441_.nextInt(5) == 0) {
            float px = (float)this.m_58899_().m_123341_() + 0.5f;
            float py = (float)this.m_58899_().m_123342_() + 0.5f + this.m_58904_().f_46441_.nextFloat() * 0.4f;
            float pz = (float)this.m_58899_().m_123343_() + 0.5f;
            float f3 = 0.9f;
            float f4 = this.m_58904_().f_46441_.nextFloat() * 0.4f;
            switch (orientation) {
                case EAST: {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)(px + f3), (double)py, (double)(pz + f4), -0.1, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)(px - f3), (double)py, (double)(pz + f4), 0.1, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)(px + f4), (double)py, (double)(pz + f3), 0.0, 0.0, -0.1);
                    break;
                }
                case NORTH: {
                    this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)(px + f4), (double)py, (double)(pz - f3), 0.0, 0.0, 0.1);
                }
            }
        }
    }

    public void updateAirHandler() {
        ArrayList<Direction> sides = new ArrayList<Direction>();
        for (Direction side : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
            if (!this.canConnectPneumatic(side)) continue;
            sides.add(side);
        }
        this.airHandler.setConnectedFaces(sides);
        logger.debug("Updated Air Handler! Side: " + this.m_58900_().m_61143_(RotationalCompressorBlock.HORIZONTAL_FACING));
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.updateGeneratedAir = true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY && this.canConnectPneumatic(side)) {
            return this.airHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean canConnectPneumatic(Direction dir) {
        Direction orientation = (Direction)this.m_58900_().m_61143_(RotationalCompressorBlock.HORIZONTAL_FACING);
        return dir != Direction.UP && dir != Direction.DOWN && dir != orientation && dir != orientation.m_122424_();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("AirHandler", this.airHandler.serializeNBT());
        if (clientPacket) {
            compound.m_128347_("airGeneratedPerTick", this.airGeneratedPerTick);
            compound.m_128379_("isWrongDirection", this.isWrongDirection);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.airHandler.deserializeNBT(compound.m_128469_("AirHandler"));
        if (clientPacket) {
            this.airGeneratedPerTick = compound.m_128459_("airGeneratedPerTick");
            this.isWrongDirection = compound.m_128471_("isWrongDirection");
        }
    }

    public boolean shouldRenderNormally() {
        return true;
    }

    @Override
    public void onObserved(ServerPlayer var1, ObservePacket var2) {
    }
}

